/*
 * Decompiled with CFR 0.152.
 */
package server.restful.servlets.rtmp;

import com.beust.jcommander.Parameters;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.HttpConstraint;
import jakarta.servlet.annotation.ServletSecurity;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.UUID;
import server.restful.common.JSIDPlay2Servlet;
import server.restful.common.ServletUtil;
import server.restful.common.parameter.ServletParameterParser;
import server.restful.common.parameter.requestparam.VideoRequestParamServletParameters;
import server.restful.common.rtmp.PlayerCleanupTimerTask;
import server.restful.common.rtmp.PlayerWithStatus;

@WebServlet(name="SetDefaultEmulationReSidServlet", displayName="SetDefaultEmulationReSidServlet", urlPatterns={"/static/set_default_emulation_resid"}, description="Set default emulation to RESID for emulator running as a RTMP live video stream")
@ServletSecurity(value=@HttpConstraint(rolesAllowed={"user", "admin"}))
public class SetDefaultEmulationReSidServlet
extends JSIDPlay2Servlet {
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            SetDefaultEmulationReSidServletParameters servletParameters = new SetDefaultEmulationReSidServletParameters();
            ServletParameterParser parser = new ServletParameterParser(request, response, servletParameters);
            if (servletParameters.getHelp().booleanValue() || parser.hasException()) {
                parser.usage();
                return;
            }
            UUID uuid = servletParameters.getUuid();
            ServletUtil.info(this.getServletContext(), String.format("setDefaultEmulationReSid: RTMP stream of: %s", uuid), new Thread[0]);
            PlayerCleanupTimerTask.update(uuid, PlayerWithStatus::setDefaultEmulationReSid);
        }
        catch (Throwable t) {
            response.setStatus(500);
            ServletUtil.error(this.getServletContext(), t, new Thread[0]);
            this.setOutput(response, t);
        }
    }

    @Parameters(resourceBundle="server.restful.servlets.rtmp.SetDefaultEmulationReSidServletParameters")
    public static class SetDefaultEmulationReSidServletParameters
    extends VideoRequestParamServletParameters {
    }
}

